
////////////////////////////////////////////////////////////
//	File:		"Frame.h"
//	Author:		[JW] Jason Ware
//	Modified:	[JW] November 17, 2008
//	Purpose:	The frame's information for animating.
////////////////////////////////////////////////////////////

#ifndef FRAME_H_
#define FRAME_H_

#include <windows.h>
#include <string>
using std::string;

class CFrame
{

public:

	/* Public Data Members */

protected:

	/* Protected Data Members */

private:

	/* Private Data Members */
	string		m_szFrameName;		// Name of the frame
	RECT		m_rFrameRect;		// The frame rectangle for a given frame
	RECT		m_rCollisionRect;	// The collision rectangle for a given frame
	int			m_nAnchorX;			// The anchor x position for a given frame
	int			m_nAnchorY;			// The anchor y position for a given frame
	float		m_fDuration;		// The duration of the frame

	/* Disabled Functions */

public:

	////////////////////////////////////////////////////////////
	//	Function:	Constructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Initializes the object.
	////////////////////////////////////////////////////////////
	CFrame() {};
	CFrame(string szFrameName) : m_szFrameName(szFrameName) {};

	////////////////////////////////////////////////////////////
	//	Function:	Accessors
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Gets the specified type.
	////////////////////////////////////////////////////////////
	inline RECT GetFrameRect(void)		{ return m_rFrameRect; }
	inline RECT GetCollisionRect(void)	{ return m_rCollisionRect; }
	inline int GetAnchorX(void)			{ return m_nAnchorX; }
	inline int GetAnchorY(void)			{ return m_nAnchorY; }
	inline float GetDuration(void)		{ return m_fDuration; }

	////////////////////////////////////////////////////////////
	//	Function:	Mutators
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Sets the specified type.
	////////////////////////////////////////////////////////////
	inline void SetFrameRect(RECT rFrameRect)		{ m_rFrameRect = rFrameRect; }
	inline void SetCollisionRect(RECT rCollRect)	{ m_rCollisionRect = rCollRect; }
	inline void SetAnchorX(int nAnchorX)			{ m_nAnchorX = nAnchorX; }
	inline void SetAnchorY(int nAnchorY)			{ m_nAnchorY = nAnchorY; }
	inline void SetDuration(float fDuration)		{ m_fDuration = fDuration; }

	////////////////////////////////////////////////////////////
	//	Function:	Destructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Deallocates the object.
	////////////////////////////////////////////////////////////
	~CFrame() {};

protected:

	/* Protected Functions */

private:

	/* Private Functions */

};

#endif
